//
//		Definition of the main game class
//
#ifndef THE_GAMEWIN_SCENE_H
#define THE_GAMEWIN_SCENE_H


#include "ldwScene.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#define cFadeInCount 50
#define cFadeOutCount 50
#define cFADE_INTERVAL  5
#define cFadeTransStep 0.020f  

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theStringManager;

class theGamewinScene : public ldwScene
{
public:

	ldwUINT32 timer;
	bool visitedAtLeastOnce;
	
	theGamewinScene();
	~theGamewinScene();
	void SetTimer();
	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);

protected:

	void DrawScene();
	void UpdateScene();

private:
	
	ldwGameWindow *gameWindow;
	theGameState  *gs;
	theStringManager *stringMgr;


	int handAdjX;
	int handAdjY;
	int fadeInCount;
	bool beginFadeOut;
	int fadeOutCount;
	bool fadeInComplete;
	bool fadeOutComplete;
	bool fullScreenMode;
	bool pointerShowing;

	float fadeTrans;

	ldwRect displayRect;

	ldwTextControl *line1;
	ldwTextControl *line2;
	ldwTextControl *line3;
	ldwTextControl *line4;
	ldwTextControl *line5;
	ldwTextControl *line6;

	ldwImageGrid *BG;
	//ldwImageGrid *canvas_bg;

	ldwRect fadeInOutRect;
	ldwUINT32 fadeTimer; 

	bool customCursor;
	bool hideCursor;
};
#endif